
$(function () {
	$("#accordion").accordion({ header: "h3" });
	$('#tabs').tabs();
	$('#dialog').dialog({
		autoOpen: false,
		width: 600,
		buttons: {
			"Ok": function() { 
				$(this).dialog("close"); 
			}, 
			"Cancel": function() { 
				$(this).dialog("close"); 
			} 
		}
	});
	$('#dialog_link').click(function(){
		$('#dialog').dialog('open');
		return false;
	});

	$('#slider').slider({
		range: true,
		values: [17, 67]
	});
	$("#progressbar").progressbar({
		value: 20 
	});
	$('#dialog_link, ul#icons li').hover(
		function() { $(this).addClass('ui-state-hover'); }, 
		function() { $(this).removeClass('ui-state-hover'); }
	);
	
	$( "button, input:submit, a", ".menu" ).button();
	
	$("a", ".menu").click(function () { return false; });

	/*$( "#logout" ).button({ icons: { primary: "ui-icon-locked" } });*/
	$( "#salva" ).button({ icons: { primary: "ui-icon-disk" } });
	$( "#refresh" ).button({ icons: { primary: "ui-icon-refresh" } });
});

function showhide(elem, act){
	if (act=='show') $(elem).show();
	else $(elem).hide();
}

function checkdurata(value, colname) {
	var msg='';
	if (((value.search(":")>=0) || (value.search(",")>=0)) && value.length>2) {
		msg=msg+'Formato durata mm.ss<br>';
	} else {
		var durata=value.split(".");
		if (durata[0] > 59 || durata[0] < 0) msg=msg+'Formato minuti 0 - 59<br>';
		if (durata[1] > 59 || durata[1] < 0) msg=msg+'Formato secondi 0 - 59<br>';
	}
	
	if (msg!='') {
		return [false,msg];
	} else { 
		return [true,""];
	}
}

function checkora(ora, colname) {
	var msg='';

	ora=ora.replace(".","");
	ora=ora.replace(".","");
	ora=ora.replace(",","");
	ora=ora.replace(",","");
	ora=ora.replace(";","");
	ora=ora.replace(";","");
	ora=ora.replace(":","");
	ora=ora.replace(":","");

	if (ora.length>6 || ora>240000 || ora<0) {
		msg=msg+'Formato ora HHMMSS (da 00:00:00 a 24:00:00)<br>';
	} else {
		var hh='00';
		var mm='00';
		var ss='00';
		
		var tmp = '000000'+ora;
		var time=tmp.substr(tmp.length-6);
	
		var hh = time.substr(0,2);
		var mm = time.substr(2,2);
		var ss = time.substr(4,2);
		
		if (hh>24) msg=msg+'Formato ora 0 - 24<br>';
		if (mm>59) msg=msg+'Formato minuti 0 - 59<br>';
		if (ss>59) msg=msg+'Formato secondi 0 - 59<br>';
		
		/*
		if(ora<=240000 && ora>=100000) {
			hh = ora.substr((ora.length-6),ora.length-4);
			mm = ora.substr((ora.length-4),(ora.length-4));
			ss = ora.substr((ora.length-2),ora.length);
		} else if(ora<100000 && ora>5900) {
			hh = '0'+ora.substr((ora.length-5),ora.length-4);
			hh = hh.substr(0,2);
			mm = ora.substr((ora.length-4),(ora.length-3));
			ss = ora.substr((ora.length-2),ora.length);
		} else if(ora<=5900 && ora>900) {
			hh = '00';
			//mm = ora.substr((ora.length-4),(ora.length-2));
			mm = ora.substr((ora.length-4),2);
			ss = ora.substr((ora.length-2),ora.length);
		} else if(ora<=900 && ora>59) {
			hh = '00';
			//mm = '0'+ora.substr((ora.length-3),(ora.length-2));
			mm = '0'+ora.substr((ora.length-3),2);
			ss = ora.substr((ora.length-2),ora.length);
			//alert(mm+' '+ss);
		} else if(ora<=59 && ora>=10) {
			hh = '00';
			mm = '00';
			ss = ora.substr((ora.length-2),ora.length);
		} else if(ora<10 && ora>0) {
			hh = '00';
			mm = '00';
			ss = '0'+ora;
		}
		if (hh>24) msg=msg+'Formato ora 0 - 24<br>';
		if (mm>59) msg=msg+'Formato minuti 0 - 59<br>';
		if (ss>59) msg=msg+'Formato secondi 0 - 59<br>';
		*/
	}
	
	
	if (msg!='') {
		return [false,msg];
	} else { 
		/*
		var orario=hh+''+mm+''+ss;
		if(colname=='starttime'){
			$("#duration").val('CIAO');
		}
		*/
		return [true,""];
	}	
}

function formatTime (duration) {
	var tmp='';
	var time='';

	duration = duration.replace( ".", "");
	duration = duration.replace( ",", "");
	duration = duration.replace( ":", "");

	duration = duration.replace( ".", "");
	duration = duration.replace( ",", "");
	duration = duration.replace( ":", "");

	
	var tmp='000000'+duration;
	time=tmp.substr(tmp.length-6);

	var hh = time.substr(0,2);
	var mm = time.substr(2,2);
	var ss = time.substr(4,2);
	
	if(hh>24) hh='00';
	if(mm>59) mm='00';
	if(ss>59) ss='00';
	time=hh+':'+mm+':'+ss;
	
	return time;
}

function formatdurata (cellvalue, options, rowObject) {
	if (cellvalue.search(":")>=0) cellvalue.replace( ":", ".");
	if (cellvalue.search(",")>=0) cellvalue.replace( ",", ".");
	var durata=cellvalue.split(".");

	if (!durata[0]) {
		durata[0]='00';
	} else {
		var tmp='000'+durata[0];
		durata[0]=tmp.substr(tmp.length-2);
	}
	
	if (!durata[1]) {
		durata[1]='00';
	} else {
		if (durata[1].length==1 && durata[1]<6) durata[1]=durata[1]+'0';
		else if (durata[1].length==1 && durata[1]>5) durata[1]='59'; //durata[1]='0'+durata[1];
		else if (durata[1].length==0) durata[1]='00';
	}
	return durata[0]+'.'+durata[1];
}

function formatOraDaDB(val) {
	val = val.toString();
	var ss = '00';
	var mm = '00';
	var hh = '00';

	if(val<=240000 && val>=100000) {
		hh = val.substr((val.length-6),val.length-4);
		mm = val.substr((val.length-4),(val.length-4));
		ss = val.substr((val.length-2),val.length);
	} else if(val<100000 && val>5900) {
		hh = '0'+val.substr((val.length-5),val.length-4);
		//hh = val.substr((val.length-5),val.length-4);
		mm = val.substr((val.length-4),(val.length-3));
		ss = val.substr((val.length-2),val.length);
	} else if(val<=5900 && val>900) {
		hh = '00';
		mm = val.substr((val.length-4),(val.length-2));
		ss = val.substr((val.length-2),val.length);
	} else if(val<=900 && val>59) {
		hh = '00';
		mm = '0'+val.substr((val.length-3),(val.length-2));
		ss = val.substr((val.length-2),val.length);
	} else if(val<=59 && val>=10) {
		hh = '00';
		mm = '00';
		ss = val.substr((val.length-2),val.length);
	} else if(val<10 && val>0) {
		hh = '00';
		mm = '00';
		ss = '0'+val;
	}
	var orario=hh+':'+mm+':'+ss;
	
	return(orario);
}

function formatOraPerDB(val) {
	var orario=val.split(":");
	var hh = orario[0];
	var mm = orario[1];
	var ss = orario[2];
	
	if (hh.substr(0,1)=='0') hh=hh.substr(1,1);
	if(hh==0) hh='';
	
	if (hh==0 || hh=='') {
		if (mm.substr(0,1)=='0') mm=mm.substr(1,1);
		if (mm==0) mm='';
	}
	
	if ((mm==0 || mm=='') && (hh==0 || hh=='')) {
		if (ss.substr(0,1)=='0') ss=ss.substr(1,1);
	}
	
	var ora=hh+''+mm+''+ss;
	return(ora);
}

function timeToMilli(val) {
	var orario=val.split(":");
	var hh = parseInt(orario[0]);
	var mm = parseInt(orario[1]);
	var ss = parseInt(orario[2]);

	return(((hh*3600)+(mm*60)+ss)*1000);
}

function milliToTime(durata) {
	var hh = '';
	var mm = '';
	var ss = '';
	
	durata = durata / 1000;
	var tmp = durata / 3600;
	tmp = tmp.toString();
	if (tmp.indexOf('.') > 0) {
		hh = tmp.substr(0, tmp.indexOf('.'));
	} else {
		hh = tmp;
	}
	if (hh < 10) hh = '0' + hh;
	
	tmp = ((durata - (hh * 3600)) / 60);
	tmp = tmp.toString();
	if (tmp.indexOf('.') > 0) mm = tmp.substr(0, tmp.indexOf('.'));
	else mm = tmp;
	if (mm < 10) mm = '0' + mm;

	tmp = durata - (hh * 3600) - (mm * 60);
	tmp = tmp.toString();
	if (tmp.indexOf('.') > 0) ss = tmp.substr(0, tmp.indexOf('.'));
	else ss = tmp;

	if (ss < 10) durata = hh + ':' + mm + ':0' + ss;
	else durata = hh + ':' + mm + ':' + ss;

	//console.log(hh + " " + mm + " " + ss);
	
		return durata;
	
}

function topmenu(val){
	if(val==1) {
		$('#topmenu').css('top','0px');
		$("#opentopmenu").html('<a href="#" onclick="javascript:topmenu(0)" style="color:#FFFFFF; text-decoration:none;">DASHBOARD</a>');
	}
	if(val==0) {
		$('#topmenu').css('top','-49px');
		$("#opentopmenu").html('<a href="#" onclick="javascript:topmenu(1)" style="color:#FFFFFF; text-decoration:none;">DASHBOARD</a>');
	}
}